package demo.forms;

import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import demo.*;
import demo.data.*;

/**
 * Ecran affichant les dtails d'une information particulire
*/
public class Details extends List implements CommandListener, IState {
  // Rfrence  la machine d'tat
  private IStateMachine parent;
  // Commande 'retour'
  private Command back;

  // Constructeurs

  /**
   * Constructeur crant un nouvel objet Details  partir du titre et de la rfrence de son IstateMachine parent
   */
  public Details(String name, IStateMachine parent) {
    super(name, List.IMPLICIT);
    this.parent = parent;
    this.back = new Command("Retour", Command.BACK, 1);
    addCommand(this.back);
    setCommandListener(this);
  }

  // Mthodes utilitaires

  /**
   * Cre l'cran avec les informations sur un Info spcifique
   */
  private void buildKBInfo(Object pinfo) {
    if (size() != 0) clearScreen();
    Info p = (Info) pinfo;
    setTitle(p.getType() + " " + p.getTitre());
    append("Type: " + p.getType(), null);
    append("Titre: " + p.getTitre(), null);
    append("Contenu: " + p.getContenu(), null);
  }

  // Supprime tous les lments de l'cran
  private void clearScreen() {
    int n = size();
    for (int i = 0; i < n; i++) delete(0);
  }

  // Mthodes du CommandListener

  /**
   * Appelle setCurrentState() sur la machine d'tat pour mettre  
   * jour l'tat
   * L'utilisateur ne peut que passer du Details au 
   * QueryResultsList
   */
  public void commandAction(Command c, Displayable d) {
    this.parent.setCurrentState(kb.STATE_QUERY_RESULTS, null);
  }

  // Mthodes de IState

  /**
   * Quand l'tat courant est modifi, affiche les dtails d'une 
   * infor particulire slectionne dans le QueryResultsScreen
   */
  public void handleTransition(Object eventData) {
    Info p = (Info) eventData;
    if (p != null) buildKBInfo(p);
  }
}
